//	DataFormats.h

#pragma once


#ifndef _DATAFORMATS_H_
#define _DATAFORMATS_H_


//	extensions used in the extension BMessage. Use of these 
//	are described in the documentation (MANUAL.txt)
//
#define kTimeExtension			"/time"
#define kFrameExtension			"/frame"
#define kBitsRectExtension		"bits/Rect"
#define kHeaderExtension		"/headerOnly"
#define kDataExtension			"/dataOnly"
#define kNoisChannelExtension	"nois/channel"
#define kNoisMonoExtension		"nois/mono"
#define kNoisMarkerExtension	"nois/marker"
#define kNoisLoopExtension		"nois/loop"


//	for each data group, there is a "standard" format that
//	all translators should support.
//
enum DATAGroups {
	DATA_BITMAP			=	'bits',		//	DATA_BITMAP
	DATA_PICTURE		=	'pict',		//	BPicture data
	DATA_TEXT			=	'TEXT',		//	B_ASCII_TYPE
	DATA_SOUND			=	'nois',		//	DATA_SOUND
	DATA_MIDI			=	'midi',		//	standard MIDI
	DATA_VIDEO			=	'ontv',		//	frames?
	DATA_EXECUTABLE		=	'BAPP',		//	PEF container
	DATA_NONE			=	'none'
};
#define kAnyType 0


//	This is the standard bitmap format
struct DATABitmap {
	ulong		magic;		//	DATA_BITMAP
	BRect		bounds;
	long		rowBytes;
	color_space	colors;
	long		dataSize;
};	//	data follows, padded to rowBytes

//	This is the standard sound format
struct DATASound {
	ulong		magic;		//	DATA_SOUND
	long		channels;	//	Left should always be first
	float		sampleFreq;	//	16 bit linear
	long		numFrames;
};	//	data follows


//	This is the standard video format. Please replace it.
struct DATAVideo {
	ulong		magic;		//	DATA_VIDEO
	BRect		bounds;		//	Union of all bitmap parts
	float		framesPerSec;
	long		soundPtr;
	long		posterFrame;
	long		numFrames;
	long		frameIndex[1];	//	actually numFrames ptrs
};	//	followed by DATABitmap and DATASound, each pointed at by frameIndex and soundPtr

#endif // _DATAFORMATS_H_

